/*
 * Names:	James Sheets
 * Class:	476
 * Due:		3/06/07
 * Desc:		Create an AbstractFactory to deal with four computer systems
 *				(Moon, AdvancedMoon, SuperMoon, UltraMoon), each of which is
 *				comprised of three components (CPU, MMU, Motherboard)
*/



import java.io.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

class Client extends JFrame implements ActionListener
{
	/*
	 * Global Variables
	*/
	public JButton start;
	public JButton fileLocationChooser;
	public JTextField fileLocation;
	
	
	/*
	 * Program entry-point
	*/
	public static void main(String[] args)
	{
      // Set L&F
      try{
         UIManager.setLookAndFeel( UIManager.getSystemLookAndFeelClassName() );
      } catch (Exception e) { }
      // Instantiate frame
      Client client = new Client();
      // Display frame
      Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
      client.pack();
      client.setLocation( 
         (screen.width - client.getSize().width)/2, 
         (screen.height - client.getSize().height)/2 
      );
      client.setResizable(false);
      client.setVisible(true);
	}
	
	
	/*
	 * Public Constructor
	 * Sets up the GUI components for our program
	*/
	public Client()
	{
		super("Abstract Factory Example");
      this.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
      
      // Create the area to select a file
      fileLocation = new JTextField(21);
      fileLocationChooser = new JButton("Select File");
      fileLocationChooser.setName("fileButton");
      JPanel one = new JPanel();
      one.add(new JLabel("Config File Location"), BorderLayout.WEST);
      one.add(fileLocation, BorderLayout.CENTER);
      one.add(fileLocationChooser, BorderLayout.EAST);
      
      // Button to start program
      start = new JButton("Start Test");
      start.setName("startButton");
      
      // Add action listeners
      fileLocationChooser.addActionListener(this);
      start.addActionListener(this);
      
      // Add everything to the frame
      GridBagConstraints c = new GridBagConstraints();
      c.gridwidth = GridBagConstraints.REMAINDER;
      this.getContentPane().setLayout(new GridBagLayout());
      this.getContentPane().add(one,c);
      this.getContentPane().add(start,c);
	}
	
	
	/*
	 * Gets system type
	 * Parses our input file, and fetches the first line from it, which we assume
	 * should exist, and should only contain the name of the system to test
	*/
	public String GetSystemType() throws IOException
	{
      // Open the file
      FileReader input = new FileReader(fileLocation.getText());
      BufferedReader bufRead = new BufferedReader(input);
      
      // We assume the file contains one string only: the file system to test
      String line = bufRead.readLine();
      bufRead.close();
      
      // Return line from the file
      return line;
	}
	
	
	/*
	 * Starts our program
	 * Gets a factory from our abstract class, and calls the test method on the
	 * cpu, mmu, and motherboard components.	Displays the result to the screen.
	*/
	public void StartTest()
	{
		String systemType = "";
		
		try 
		{
			// Fetch the system type from our file
			systemType = GetSystemType();
			
			// Get our factory
			AbstractMoonFactory factory;
			factory = AbstractMoonFactory.getFactory(systemType.trim());
			
			// Get the components for our system
			AbstractCPU cpu = factory.CPU();
			AbstractMMU mmu = factory.MMU();
			AbstractMotherboard mobo = factory.Motherboard();
			
			// Call the test function on our components
			warning(cpu.test() + "\n" + mmu.test() + "\n" + mobo.test());
			//cpu.test();
			//mmu.test();
			//mobo.test();
		} 
		catch (IOException e)
		{
			warning("Error opening config file");
		}
		catch (NoFactoryException ex)
		{
			warning("No system named '" +systemType+ "' exists");
		}
	}
	
	
	/*
	 * Display a warning message to the user
	*/
	public void warning(String s)
	{
		// Display message in a dialog box
		JOptionPane.showMessageDialog(this, s);
	}
	
	
	/*
	 * Listen for events
	 * If the file chooser button is pressed, show the proper dialog.
	 * If the start button is pressed, begin the program.
	*/
	public void actionPerformed(ActionEvent ae)
	{
      // Figure out which component triggered the event
      Object source = ae.getSource();
      if (source instanceof Component)
      {
         // Box the source to a Component (Superclass of all GUI widgets)
         Component comp = (Component)source;
         
         // Start button was pressed
         if (comp.getName().equals("startButton"))
         {
            // No file specified; error
            if (fileLocation.getText().length() <= 0)
               warning("You need to specify the location of the configuration file");
            // Start
            else
               StartTest();
         }
      
         // File chooser button was pressed
         else if (comp.getName().equals("fileButton"))
         {
            // Instantiate file chooser
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showOpenDialog(this);
            // When a file is chosen, put its path in the file text field
            if(returnVal == JFileChooser.APPROVE_OPTION) 
               fileLocation.setText( chooser.getSelectedFile().getAbsolutePath() );
         }
      }
	}
	
	
}
